*! version 5.0
* 13 August 2018
* NIDS
* Master Expenditure do file updated for Nids Wave 4

* THIS IS 3rd EXPENDITURE DO FILE - PREPARING VARIABLES FOR IMPUTATION: 3 OF 6
* THIS DO FILE PREPARES THE RELEVANT INCOME VARIABLES FOR IMPUTATION

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Expenditure do file (1 of 6)"

version 12.1

*=====================================================================================================================================
*USING THE ADULT AND INDDERIVED FILES TO CREATE A BIOCHILDREN VARIABLE
* Counting the number of biological children 18 or younger still living in this household


*Reshaping the adult questionnaire into long format (birth history variables)

use "$DataIN\Adult_$VersionIN.dta", clear

rename w4_a_* *

keep pid w4_hhid bhres* bhchild_id*
reshape long bhchild_id bhres, i(pid) j(child)

gen issue=1 if bhres==1 & bhchild_id==.
gen issue_d=issue!=.
label variable issue_d "resisdent children with no id"
rename pid m_pid
rename bhchild_id pid

*Merging with individual derived file
drop if pid == .
duplicates drop pid, force   //TEMP FIX. MICHELLE TO DROP ONCE BH SECTION IS FIXED

merge 1:1 pid using "$DataIN\indderived_$VersionIN.dta"
drop if _m == 2
drop _merge

*drop w4_hhid
rename w4_* *
rename hhid w4_hhid
gen hhchild=0
replace hhchild = 1 if best_age_yrs<=18 & best_age_yrs>=0

gen biochild=0
replace biochild=1 if m_pid!=. & hhchild==1
egen biochildren = sum(biochild), by(m_pid)

keep pid m_pid w4_hhid biochildren issue_d
drop pid
rename m_pid pid
keep pid w4_hhid biochildren issue_d

duplicates drop pid, force


*------------------------------------------------------------------------------------------------------------------------------------


* MERGING WITH THE DATASET CREATED IN THE DO FILE "Income - Merging datasets to create income variables (2 of 7)"
merge 1:1 pid  using "$DataOUT\data.dta"
drop _merge

*-------------------------------------------------------------------------------------------------------------------------------------

* RESPONSE STATUS

gen response=1 if hh_outcome==1
label variable response "Did household respond or not"
label values response dummy

*Variable that indicates the outcome of attempted sampling of this unit
gen responseoutcome=response
replace responseoutcome=2 if proxy==1
label define responseoutcome 0 "Non-response" 1 "Adult" 2 "Proxy"
label values responseoutcome responseoutcome 


*-------------------------------------------------------------------------------------------------------------------------------------

* DEMOGRAPHICS

* Gender

recode best_gen (1=1 "Male") (2=0 "Female"), gen(male)
replace male=roster_male if male==.
label variable male "Male dummy"
gen male_d=male!=.

*-------------------------------------------------------------------------------------------------------------------------------------
* Race
******

rename best_race race
recode race (min/0=.)
gen race_d=race!=.
recode race (1=1 "African") (2/4=0 "Non-African"), gen(african)
recode race (2=1 "Coloured") (3/4=0 "Non-Coloured") (1=0 "Non-Coloured") , gen(coloured)
recode race (3=1 "Asian_Indian") (1/2=0 "Non-asian_indian") (4=0 "Non-asian_indian"), gen(asian_indian)
recode race (4=1 "White") (1/3=0 "Non-White"), gen(white)
recode race (5=1 "Other") (1/4=0 "Non-Other"), gen(other)

* Age
******

recode best_age_yrs (min/-1=.)
replace best_age_yrs=0 if best_age_yrs==.
gen age_d=best_age_yrs==0
gen agesq=best_age_yrs^2
label variable agesq "Age squared at interview"
gen agecu=best_age_yrs^3
label variable agecu "Age cubed at interview"

* Schooling
***********

recode best_edu (-9/0=0) (1=1 "Grade 1") (2=2 "Grade 2") (3=3 "Grade 3") (4=4 "Grade 4") (5=5 "Grade 5") ///
(6=6 "Grade 6") (7=7 "Grade 7") (8=8 "Grade 8") (9=9 "Grade 9") (10=10 "Grade 10") (11=11 "Grade 11") ///
(12=12 "Grade 12") (13=10) (14=11) (15=12) (25=0 "No schooling") (16/24=12) (26/max=.), gen(schooling)
gen schooling_d=schooling!=.
gen schoolingsq=schooling^2
label variable schooling "Schooling"

*Education dummies
recode best_edu (-9/0=0) (0/12=0) (12/15=0) (25=0), gen(postschool)
replace postschool=0 if best_edu<0 & best_edu>=-9 & schooling<12
gen postschool_d=postschool!=.
tab postschool, gen(edu)
rename edu2 cert_nomat
rename edu3 dip_nomat
rename edu4 cert_mat
rename edu5 dip_mat
rename edu6 bachelors
rename edu7 bach_dip
rename edu8 honours
rename edu9 postgrad
rename edu10 othered

*Number of post-school years
recode postschool (16/17=1) (18/19=1) (20=3) (21=4) (22=4) (23=6) (24=0), gen(postschoolyears)

*Proxy for work experience
gen experience=best_age_yrs-6-schooling-postschoolyears

*Trade union membership
gen tradeunion=em1tru==1
label variable tradeunion "Trade union membership"

*-------------------------------------------------------------------------------------------------------------------------------------

* HOUSEHOLD-LEVEL VARIABLE

*Household mode race
egen hhrace=mode(race), by(w4_hhid) minmode
egen hhracetemp=mode(race), by(w4_hhid) maxmode
replace hhrace=hhracetemp if hhrace==.
drop hhracetemp
gen hhrace_d=hhrace!=.
replace hhrace=0 if hhrace==.
gen hhafrican=hhrace==1
gen hhcoloured=hhrace==2
gen hhindian=hhrace==3
gen hhwhite=hhrace==4
gen hhother=hhrace==5

*Maximum household education
egen hhedu=max(schooling), by(w4_hhid)
egen hhpostedu=max(postschool), by(w4_hhid)
recode hhpostedu (16/17=12) (18/19=13) (20/21=15) (22=16) (23=17) (24=.)
replace hhedu=hhpostedu if hhpostedu!=0 & hhpostedu!=.
replace hhedu=0 if hhedu==. & response==1
gen hhedusq=hhedu^2

*Median household age
egen hhage=median(best_age_yrs) if best_age_yrs>=0 & best_age_yrs<110, by(w4_hhid)
gen hhage_d=hhage!=.
replace hhage=0 if hhage==.

*Dummy for household receiving grant income
gen spen_rec=1 if incgovpen==1
replace spen_rec=0 if spen_rec!=1 & response==1 
gen dis_rec=1 if incdis==1
replace dis_rec=0 if dis_rec!=1 & response==1 
gen chld_rec=1 if incchld==1
replace chld_rec=0 if chld_rec!=1 & response==1 
gen fost_rec=1 if incfos==1
replace fost_rec=0 if fost_rec!=1 & response==1 
gen care_rec=1 if inccare==1
replace care_rec=0 if care_rec!=1 & response==1 

gen hhgrant=0
replace hhgrant=1 if spen_rec==1 | dis_rec==1 | chld_rec==1 | fost_rec==1 | care_rec==1
egen temp=sum(hhgrant), by(w4_hhid)
gen temp2=temp>0 & temp!=.
replace hhgrant=temp2
drop temp*

*Dummy for there being any children in the household
gen hhchld_d=hhchildren>0 & hhchildren!=.

sort w4_hhid
drop if w4_hhid==w4_hhid[_n-1]

keep w4_hhid hhsizer hhintmonth hhgrant hhchildren hometype homewalls homeroof homerooms homeroomssq ///
homerooms_d hhrace hhrace_d hhedu hhedusq hhage hhage_d hhchld_d hhafrican hhcoloured hhindian hhwhite ///
hhother hrcorr hometype_d homewalls_d homeroof_d rentpay rentpay_rec rentpay_d hh_outcome geo2011

sort w4_hhid
merge 1:1 w4_hhid using "$DataIN\HHQuestionnaire_$VersionIN.dta"
cap rename w4_h_* *
keep if _merge==3
drop _merge

* Household Resonse
gen hhresponse=hh_outcome==1

*PREPARING THE FOOD EXPENDITURE VARIABLES

recode fdmm (min/-3=0) (.=0) (2=0), gen(fd1_rec)
recode fdsmp (min/-3=0) (.=0) (2=0), gen(fd2_rec)
recode fdflr (min/-3=0) (.=0) (2=0), gen(fd3_rec)
recode fdrice (min/-3=0) (.=0) (2=0), gen(fd4_rec)
recode fdpas (min/-3=0) (.=0) (2=0), gen(fd5_rec)
recode fdbis (min/-3=0) (.=0) (2=0), gen(fd6_rec)
recode fdrm (min/-3=0) (.=0) (2=0), gen(fd7_rec)
recode fdrmc (min/-3=0) (.=0) (2=0), gen(fd8_rec)
recode fdchi (min/-3=0) (.=0) (2=0), gen(fd9_rec)
recode fdfsh (min/-3=0) (.=0) (2=0), gen(fd10_rec)
recode fdfshc (min/-3=0) (.=0) (2=0), gen(fd11_rec)
recode fdvegd (min/-3=0) (.=0) (2=0), gen(fd12_rec)
recode fdpot (min/-3=0) (.=0) (2=0), gen(fd13_rec)
recode fdvego (min/-3=0) (.=0) (2=0), gen(fd14_rec)
recode fdfru (min/-3=0) (.=0) (2=0), gen(fd15_rec)
recode fdoil (min/-3=0) (.=0) (2=0), gen(fd16_rec)
recode fdmar (min/-3=0) (.=0) (2=0), gen(fd17_rec)
recode fdpb (min/-3=0) (.=0) (2=0), gen(fd18_rec)
recode fdmlk (min/-3=0) (.=0) (2=0), gen(fd19_rec)
recode fdegg (min/-3=0) (.=0) (2=0), gen(fd20_rec)
recode fdsug (min/-3=0) (.=0) (2=0), gen(fd21_rec)
recode fdsd (min/-3=0) (.=0) (2=0), gen(fd22_rec)
recode fdfrut (min/-3=0) (.=0) (2=0), gen(fd23_rec)
recode fdcer (min/-3=0) (.=0) (2=0), gen(fd24_rec)
recode fdbaby (min/-3=0) (.=0) (2=0), gen(fd25_rec)
recode fdslt (min/-3=0) (.=0) (2=0), gen(fd26_rec)
recode fdsoy (min/-3=0) (.=0) (2=0), gen(fd27_rec)
recode fdcof (min/-3=0) (.=0) (2=0), gen(fd28_rec)
recode fdhmp (min/-3=0) (.=0) (2=0), gen(fd29_rec)
recode fdrdy (min/-3=0) (.=0) (2=0), gen(fd30_rec)
recode fdout (min/-3=0) (.=0) (2=0), gen(fd31_rec)
recode fdo (min/-3=0) (.=0) (2=0), gen(fd32_rec)

foreach var of varlist fdmmspn fdmmpay fdmmprd fdmmss ///
fdsmpspn fdsmppay fdsmpprd fdsmpss ///
fdflrspn fdflrpay fdflrss ///
fdricespn fdricepay fdricess ///
fdpasspn fdpaspay fdpasss ///
fdbisspn fdbispay fdbisss ///
fdrmspn fdrmpay fdrmprd fdrmss ///
fdrmcspn fdrmcpay fdrmcss ///
fdchispn fdchipay fdchiprd fdchiss ///
fdfshspn fdfshpay fdfshprd fdfshss ///
fdfshcspn fdfshcpay fdfshcss ///
fdvegdspn fdvegdss ///
fdpotspn fdpotpay fdpotprd fdpotss ///
fdvegospn fdvegopay fdvegoprd fdvegoss ///
fdfruspn fdfrupay fdfruprd fdfruss ///
fdoilspn fdoilpay fdoilss ///
fdmarspn fdmarpay fdmarprd fdmarss ///
fdpbspn fdpbpay fdpbss ///
fdmlkspn fdmlkpay fdmlkprd fdmlkss ///
fdeggspn fdeggpay fdeggprd fdeggss ///
fdsugspn fdsugpay fdsugprd fdsugss ///
fdsdspn fdsdpay fdsdss ///
fdfrutspn fdfrutpay fdfrutss ///
fdcerspn fdcerpay fdcerss ///
fdbabyspn fdbabypay fdbabyss ///
fdsltspn fdsltpay fdsltprd fdsltss ///
fdsoyspn fdsoypay fdsoyss ///
fdcofspn fdcofpay fdcofprd fdcofss ///
fdhmpspn fdhmppay fdhmpss ///
fdrdyspn fdrdypay fdrdyss ///
fdoutspn fdoutpay fdoutss ///
fdospn fdopay fdoss {
recode `var' (min/0=.)
}

egen fd1=rowtotal(fdmmspn fdmmpay fdmmprd fdmmss)
egen fd2=rowtotal(fdsmpspn fdsmppay fdsmpprd fdsmpss)
egen fd3=rowtotal(fdflrspn fdflrpay fdflrss)
egen fd4=rowtotal(fdricespn fdricepay fdricess)
egen fd5=rowtotal(fdpasspn fdpaspay fdpasss)
egen fd6=rowtotal(fdbisspn fdbispay fdbisss)
egen fd7=rowtotal(fdrmspn fdrmpay fdrmprd fdrmss)
egen fd8=rowtotal(fdrmcspn fdrmcpay fdrmcss)
egen fd9=rowtotal(fdchispn fdchipay fdchiprd fdchiss)
egen fd10=rowtotal(fdfshspn fdfshpay fdfshprd fdfshss)
egen fd11=rowtotal(fdfshcspn fdfshcpay fdfshcss)
egen fd12=rowtotal(fdvegdspn fdvegdss)
egen fd13=rowtotal(fdpotspn fdpotpay fdpotprd fdpotss)
egen fd14=rowtotal(fdvegospn fdvegopay fdvegoprd fdvegoss)
egen fd15=rowtotal(fdfruspn fdfrupay fdfruprd fdfruss)
egen fd16=rowtotal(fdoilspn fdoilpay fdoilss)
egen fd17=rowtotal(fdmarspn fdmarpay fdmarprd fdmarss)
egen fd18=rowtotal(fdpbspn fdpbpay fdpbss)
egen fd19=rowtotal(fdmlkspn fdmlkpay fdmlkprd fdmlkss)
egen fd20=rowtotal(fdeggspn fdeggpay fdeggprd fdeggss)
egen fd21=rowtotal(fdsugspn fdsugpay fdsugprd fdsugss)
egen fd22=rowtotal(fdsdspn fdsdpay fdsdss)
egen fd23=rowtotal(fdfrutspn fdfrutpay fdfrutss)
egen fd24=rowtotal(fdcerspn fdcerpay fdcerss)
egen fd25=rowtotal(fdbabyspn fdbabypay fdbabyss)
egen fd26=rowtotal(fdsltspn fdsltpay fdsltprd fdsltss)
egen fd27=rowtotal(fdsoyspn fdsoypay fdsoyss)
egen fd28=rowtotal(fdcofspn fdcofpay fdcofprd fdcofss)
egen fd29=rowtotal(fdhmpspn fdhmppay fdhmpss)
egen fd30=rowtotal(fdrdyspn fdrdypay fdrdyss)
egen fd31=rowtotal(fdoutspn fdoutpay fdoutss)
egen fd32=rowtotal(fdospn fdopay fdoss)

recode fdtot (min/0=.), gen(totfood)
gen totfood_rec=hhresponse==1
gen totfood_d=totfood!=.

gen temp=.
replace temp = 250 if fdtot_brac3==3					// <500
replace temp = 500 if fdtot_brac3==2					// =500
replace temp = 625 if fdtot_brac3==1 & fdtot_brac2==3	// >500 & <750
replace temp = 750 if fdtot_brac2==2					// =750
replace temp = 975 if fdtot_brac2==1 & fdtot_brac1==3	// >750 & <1200
replace temp = 1200 if fdtot_brac1==2					// =1200
replace temp = 1500 if fdtot_brac1==1 & fdtot_brac4==3	// >1200 & <1800
replace temp = 1800 if fdtot_brac4==2					// =1800
replace temp = 2400 if fdtot_brac4==1 & fdtot_brac5==3	// >1800 & <3000
replace temp = 3000 if fdtot_brac5==2					// =3000
replace temp = 4000 if fdtot_brac5==1 & fdtot_brac6==3	// >3000 & <5000
replace temp = 5000 if fdtot_brac6==2					// =5000
replace temp = 10000 if fdtot_brac6==1					// >5000


replace totfood=temp if fdtot <0  & totfood==.
drop temp


forvalues q=1/32 {
replace fd`q'=. if fd`q'==0
replace fd`q'=. if fd`q'_rec!=1
gen fd`q'_d=fd`q'!=.
}

*PREPARING THE NON-FOOD EXPENDITURE VARIABLES

foreach var of varlist nfcigspn nfalcspn nfentspn nfsprspn nfperspn nfjewspn nfpapspn nfcelspn nftelspn ///
nflotspn nfnetspn nftrpspn nfcerspn nfcarspn nfpetrspn nftranspn nfwatspn nfelespn nfenespn nfmunspn ///
nflevspn nfinsl nfinsf nfinsedu nfinsshspn nfkitspn nfdwlspn nfbedspn nfmatspn nfhpspn nffrnspn nfclthspn ///
nfclthaspn nfclthmspn nfmedaidspn nfdocspn nfhspspn nfmedspn nftradspn nfhomspn nfschfeespn nfschstatspn ///
nfschunispn nfschospn nfwshspn nfchldspn nfrelspn nfdomspn nfswimspn nfpetsspn nftoysspn nfgftsspn nflobspn ///
{
replace `var'=. if hhresponse!=1
gen countmis`var'=`var'<0
replace countmis`var'=. if hhresponse==0
}

/*
This code is a remnant of the process undertaken in Wave 2 where there were problems with
high numbers of missing categories. It is retained in the Wave 4 do files, even though the
problem does not arise.
*/

egen countmis=rowtotal(countmis*), m
gen setmis=countmis>39 & countmis!=.

foreach var of varlist nfcigspn nfalcspn nfentspn nfsprspn nfperspn nfjewspn nfpapspn nfcelspn nftelspn ///
nflotspn nfnetspn nftrpspn nfcerspn nfcarspn nfpetrspn nftranspn nfwatspn nfelespn nfenespn nfmunspn ///
nflevspn nfinsl nfinsf nfinsedu nfinsshspn nfkitspn nfdwlspn nfbedspn nfmatspn nfhpspn nffrnspn nfclthspn ///
nfclthaspn nfclthmspn nfmedaidspn nfdocspn nfhspspn nfmedspn nftradspn nfhomspn nfschfeespn nfschstatspn ///
nfschunispn nfschospn nfwshspn nfchldspn nfrelspn nfdomspn nfswimspn nfpetsspn nftoysspn nfgftsspn nflobspn ///
{
replace `var'=. if setmis==1
replace `var'=. if hhresponse!=1
}

drop countmis countmis*

gen nf1_rec=nfcigspn!=0 & nfcigspn!=.
gen nf2_rec=nfalcspn!=0 & nfalcspn!=.
gen nf3_rec=nfentspn!=0 & nfentspn!=.
gen nf4_rec=nfsprspn!=0 & nfsprspn!=.
gen nf5_rec=nfperspn!=0 & nfperspn!=.
gen nf6_rec=nfjewspn!=0 & nfjewspn!=.
gen nf7_rec=nfpapspn!=0 & nfpapspn!=.
gen nf8_rec=nfcelspn!=0 & nfcelspn!=.
gen nf9_rec=nftelspn!=0 & nftelspn!=.
gen nf10_rec=nflotspn!=0 & nflotspn!=.
gen nf11_rec=nfnetspn!=0 & nfnetspn!=.
gen nf12_rec=nftrpspn!=0 & nftrpspn!=.
gen nf13_rec=nfcerspn!=0 & nfcerspn!=.
gen nf14_rec=nfcarspn!=0 & nfcarspn!=.
gen nf15_rec=nfpetrspn!=0 & nfpetrspn!=.
gen nf16_rec=nftranspn!=0 & nftranspn!=.
gen nf17_rec=nfwatspn!=0 & nfwatspn!=.
gen nf18_rec=nfelespn!=0 & nfelespn!=.
gen nf19_rec=nfenespn!=0 & nfenespn!=.
gen nf20_rec=nfmunspn!=0 & nfmunspn!=.
gen nf21_rec=nflevspn!=0 & nflevspn!=.
gen nf22_rec=nfinsl!=0 & nfinsl!=.
gen nf23_rec=nfinsf!=0 & nfinsf!=.
gen nf24_rec=nfinsedu!=0 & nfinsedu!=.
gen nf25_rec=nfinsshspn!=0 & nfinsshspn!=.
gen nf26_rec=nfkitspn!=0 & nfkitspn!=.
gen nf27_rec=nfdwlspn!=0 & nfdwlspn!=.
gen nf28_rec=nfbedspn!=0 & nfbedspn!=.
gen nf29_rec=nfmatspn!=0 & nfmatspn!=.
gen nf30_rec=nfhpspn!=0 & nfhpspn!=.
gen nf31_rec=nffrnspn!=0 & nffrnspn!=.
gen nf32_rec=nfclthspn!=0 & nfclthspn!=.
gen nf33_rec=nfclthaspn!=0 & nfclthaspn!=.
gen nf34_rec=nfclthmspn!=0 & nfclthmspn!=.
gen nf35_rec=nfmedaidspn!=0 & nfmedaidspn!=.
gen nf36_rec=nfdocspn!=0 & nfdocspn!=.
gen nf37_rec=nfhspspn!=0 & nfhspspn!=.
gen nf38_rec=nfmedspn!=0 & nfmedaidspn!=.
gen nf39_rec=nftradspn!=0 & nftradspn!=.
gen nf40_rec=nfhomspn!=0 & nfhomspn!=.
gen nf41_rec=nfschfeespn!=0 & nfschfeespn!=.
gen nf42_rec=nfschstatspn!=0 & nfschstatspn!=.
gen nf43_rec=nfschunispn!=0 & nfschunispn!=.
gen nf44_rec=nfschospn!=0 & nfschospn!=.
gen nf45_rec=nfwshspn!=0 & nfwshspn!=.
gen nf46_rec=nfchldspn!=0 & nfchldspn!=.
gen nf47_rec=nfrelspn!=0 & nfrelspn!=.
gen nf48_rec=nfdomspn!=0 & nfdomspn!=.
gen nf49_rec=nfswimspn!=0 & nfswimspn!=.
gen nf50_rec=nfpetsspn!=0 & nfpetsspn!=.
gen nf51_rec=nftoysspn!=0 & nftoysspn!=.
gen nf52_rec=nfgftsspn!=0 & nfgftsspn!=.
gen nf53_rec=nflobspn!=0 & nflobspn!=.

recode nfcigspn (min/0=.), g(nf1)
recode nfalcspn (min/0=.), g(nf2)
recode nfentspn (min/0=.), g(nf3)
recode nfsprspn (min/0=.), g(nf4)
recode nfperspn (min/0=.), g(nf5)
recode nfjewspn (min/0=.), g(nf6)
recode nfpapspn (min/0=.), g(nf7)
recode nfcelspn (min/0=.), g(nf8)
recode nftelspn (min/0=.), g(nf9)
recode nflotspn (min/0=.), g(nf10)
recode nfnetspn (min/0=.), g(nf11)
recode nftrpspn (min/0=.), g(nf12)
recode nfcerspn (min/0=.), g(nf13)
recode nfcarspn (min/0=.), g(nf14)
recode nfpetrspn (min/0=.), g(nf15)
recode nftranspn (min/0=.), g(nf16)
recode nfwatspn (min/0=.), g(nf17)
recode nfelespn (min/0=.), g(nf18)
recode nfenespn (min/0=.), g(nf19)
recode nfmunspn (min/0=.), g(nf20)
recode nflevspn (min/0=.), g(nf21)
recode nfinsl (min/0=.), g(nf22)
recode nfinsf (min/0=.), g(nf23)
recode nfinsedu (min/0=.), g(nf24)
recode nfinsshspn (min/0=.), g(nf25)
recode nfkitspn (min/0=.), g(nf26)
recode nfdwlspn (min/0=.), g(nf27)
recode nfbedspn (min/0=.), g(nf28)
recode nfmatspn (min/0=.), g(nf29)
recode nfhpspn (min/0=.), g(nf30)
recode nffrnspn (min/0=.), g(nf31)
recode nfclthspn (min/0=.), g(nf32)
recode nfclthaspn (min/0=.), g(nf33)
recode nfclthmspn (min/0=.), g(nf34)
recode nfmedaidspn (min/0=.), g(nf35)
recode nfdocspn (min/0=.), g(nf36)
recode nfhspspn (min/0=.), g(nf37)
recode nfmedspn (min/0=.), g(nf38)
recode nftradspn (min/0=.), g(nf39)
recode nfhomspn (min/0=.), g(nf40)
recode nfschfeespn (min/0=.), g(nf41)
recode nfschstatspn (min/0=.), g(nf42)
recode nfschunispn (min/0=.), g(nf43)
recode nfschospn (min/0=.), g(nf44)
recode nfwshspn (min/0=.), g(nf45)
recode nfchldspn (min/0=.), g(nf46)
recode nfrelspn (min/0=.), g(nf47)
recode nfdomspn (min/0=.), g(nf48)
recode nfswimspn (min/0=.), g(nf49)
recode nfpetsspn (min/0=.), g(nf50)
recode nftoysspn (min/0=.), g(nf51)
recode nfgftsspn (min/0=.), g(nf52)
recode nflobspn (min/0=.), g(nf53)

forvalues q=1/53 {
replace nf`q'=. if nf`q'==0
replace nf`q'=. if nf`q'_rec!=1
replace nf`q'_rec=. if setmis==1
gen nf`q'_d=nf`q'!=.
}

*PREPARING THE ONE-SHOT EXPENDITURE VARIABLE
gen totexp_rec=1 if hhresponse==1
recode expnd (min/0=.), g(totexp)
gen totexp_d=totexp!=.
replace totexp_d=. if hhresponse!=1

save "$DataOUT\prep.dta", replace 

* end of do file

*==================================================================================================================================================
